import { Injectable, InternalServerErrorException } from '@nestjs/common';
import { HttpService } from '@server/shared/http';

import { SplitUserStat } from './api-types/user-stat';

@Injectable()
export class SplitService {
  constructor(private http: HttpService) {}

  async getUserStatByUid(uid: string): Promise<SplitUserStat> {
    try {
      const splitRequestResult = await this.http.get('/passport/user/stat', {
        headers: {
          'X-Yandex-Uid': uid,
        },
      });

      return splitRequestResult.data;
    } catch (error) {
      throw new InternalServerErrorException(error);
    }
  }
}
