import { AccountGeolocation } from './AccountGeolocation';
import { BrowserInfo } from './BrowserInfo';
import { OsInfo } from './OsInfo';

export enum AccountAuthType {
  IMAP = 'imap',
  SMTP = 'smtp',
  POP3 = 'pop3',
  XMPP = 'xmpp',
  WebDav = 'webdav',
  Calendar = 'calendar',
  Web = 'web',
  PasswordOAuth = 'password-oauth',
}

export enum AccountActionType {
  AppPasswordEnabled = 'app_password_enabled',
  AppPasswordsDisabled = 'app_passwords_disabled',
  EmailAdd = 'email_add',
  EmailRemove = 'email_remove',
  EmailRemoveAll = 'email_remove_all',
  GlobalLogout = 'global_logout',
  QuestionsChange = 'questions_change',
  QuestionsRemove = 'questions_remove',
  PasswordChange = 'password_change',
  PasswordRemove = 'password_remove',
  WebSessionsRevoked = 'web_sessions_revoked',
  TokensRevoked = 'tokens_revoked',
  AppPasswordsRevoked = 'app_passwords_revoked',
  PersonalData = 'personal_data',
  SecurePhoneSet = 'secure_phone_set',
  SecurePhoneReplace = 'secure_phone_replace',
  SecurePhoneUnset = 'secure_phone_unset',
  PhoneBind = 'phone_bind',
  PhoneUnbind = 'phone_unbind',
  Restore = 'restore',
  TotpEnabled = 'totp_enabled',
  TotpMigrated = 'totp_migrated',
  TotpDisabled = 'totp_disabled',
  Login = 'login',
}

export interface AccountChangedField {
  key: string;
  value: string | null;
}

export interface BaseAccountAction {
  timestamp: number;
  browser?: BrowserInfo;
  os?: OsInfo;
  geolocation: AccountGeolocation;
}

export interface AccountAppPasswordEnabledAction extends BaseAccountAction {
  type: AccountActionType.AppPasswordEnabled;
}

export interface AccountAppPasswordsDisabledAction extends BaseAccountAction {
  type: AccountActionType.AppPasswordsDisabled;
}

export interface AccountEmailAddAction extends BaseAccountAction {
  type: AccountActionType.EmailAdd;
  emailBind: string;
}

export interface AccountEmailRemoveAction extends BaseAccountAction {
  type: AccountActionType.EmailRemove;
  emailUnbind: string;
}

export interface AccountEmailRemoveAllAction extends BaseAccountAction {
  type: AccountActionType.EmailRemoveAll;
}

export interface AccountGlobalLogoutAction extends BaseAccountAction {
  type: AccountActionType.GlobalLogout;
}

export interface AccountQuestionsChangeAction extends BaseAccountAction {
  type: AccountActionType.QuestionsChange;
}

export interface AccountQuestionsRemoveAction extends BaseAccountAction {
  type: AccountActionType.QuestionsRemove;
}

export interface AccountPasswordChangeAction extends BaseAccountAction {
  type: AccountActionType.PasswordChange;
}

export interface AccountPasswordRemoveAction extends BaseAccountAction {
  type: AccountActionType.PasswordRemove;
}

export interface AccountWebSessionsRevokedAction extends BaseAccountAction {
  type: AccountActionType.WebSessionsRevoked;
}

export interface AccountTokensRevokedAction extends BaseAccountAction {
  type: AccountActionType.TokensRevoked;
}

export interface AccountAppPasswordsRevokedAction extends BaseAccountAction {
  type: AccountActionType.AppPasswordsRevoked;
}

export interface AccountPersonalDataAction extends BaseAccountAction {
  type: AccountActionType.PersonalData;
  changedFields: AccountChangedField[];
}

export interface AccountSecurePhoneSetAction extends BaseAccountAction {
  type: AccountActionType.SecurePhoneSet;
  phoneSet: string;
}

export interface AccountSecurePhoneReplaceAction extends BaseAccountAction {
  type: AccountActionType.SecurePhoneReplace;
  phoneSet: string;

  phoneUnset: string;
}

export interface AccountSecurePhoneUnsetAction extends BaseAccountAction {
  type: AccountActionType.SecurePhoneUnset;
  phoneUnset: string;
}

export interface AccountPhoneBindAction extends BaseAccountAction {
  type: AccountActionType.PhoneBind;
  phoneBind: string;
}

export interface AccountPhoneUnbindAction extends BaseAccountAction {
  type: AccountActionType.PhoneUnbind;
  phoneUnbind: string;
}

export enum AccountRestoreByType {
  Link = 'link',
  PhoneAnd2faFactor = 'phone_and_2fa_factor',
  Hint = 'hint',
  SemiAuto = 'semi_auto',
  Email = 'email',
  Phone = 'phone',
}

export interface AccountRestoreByLink {
  type: AccountRestoreByType.Link;
}

export interface AccountRestoreByPhoneAnd2fa {
  type: AccountRestoreByType.PhoneAnd2faFactor;
}

export interface AccountRestoreByHint {
  type: AccountRestoreByType.Hint;
}

export interface AccountRestoreBySemiAuto {
  type: AccountRestoreByType.SemiAuto;
}

export interface AccountRestoreByEmail {
  type: AccountRestoreByType.Email;
  email: string;
}

export interface AccountRestoreByPhone {
  type: AccountRestoreByType.Phone;
  phone: string;
}

export type AccountRestoreBy =
  | AccountRestoreByLink
  | AccountRestoreByPhoneAnd2fa
  | AccountRestoreByHint
  | AccountRestoreBySemiAuto
  | AccountRestoreByEmail
  | AccountRestoreByPhone;

export interface AccountRestoreAction extends BaseAccountAction {
  type: AccountActionType.Restore;
  restoreBy: AccountRestoreBy;
}

export interface AccountTotpEnabledAction extends BaseAccountAction {
  type: AccountActionType.TotpEnabled;
}

export interface AccountTotpMigratedAction extends BaseAccountAction {
  type: AccountActionType.TotpMigrated;
}

export interface AccountTotpDisabledAction extends BaseAccountAction {
  type: AccountActionType.TotpDisabled;
}

export interface AccountLoginAction extends BaseAccountAction {
  type: AccountActionType.Login;
  authType: AccountAuthType;
}

export type AccountAction =
  | AccountAppPasswordEnabledAction
  | AccountAppPasswordsDisabledAction
  | AccountEmailAddAction
  | AccountEmailRemoveAction
  | AccountEmailRemoveAllAction
  | AccountGlobalLogoutAction
  | AccountQuestionsChangeAction
  | AccountQuestionsRemoveAction
  | AccountPasswordChangeAction
  | AccountPasswordRemoveAction
  | AccountWebSessionsRevokedAction
  | AccountTokensRevokedAction
  | AccountAppPasswordsRevokedAction
  | AccountPersonalDataAction
  | AccountSecurePhoneSetAction
  | AccountSecurePhoneReplaceAction
  | AccountSecurePhoneUnsetAction
  | AccountRestoreAction
  | AccountTotpEnabledAction
  | AccountTotpMigratedAction
  | AccountTotpDisabledAction
  | AccountLoginAction
  | AccountPhoneBindAction
  | AccountPhoneUnbindAction;
