module '@vertis/luster-bunker' {
  export interface BunkerConnection {
    family: 6 | 4;
    timeout: number;
    maxRetries: number;
    requestId: string;
    host: string;
    port: number;
    agent: {
      name: string;
      maxSockets: number;
    };
  }

  export type Nodes = Array<{
    node: string;
    version: 'stable' | 'latest';
  }>;
}

module '@vertis/luster-bunker/lib/bunker' {
  export default class Bunker {
    constructor(options: BunkerConnection);
    loadNodes<TResult = unknown>(nodes: Nodes): Promise<TResult>;
  }
}
