import type { IncomingMessage } from 'http';

import type { GraphQLSchema } from 'graphql';
import type { NextPageContext as BaseNextPageContext, NextComponentType } from 'next';
import type { AppContext as BaseAppContext } from 'next/app';
import type { DocumentContext as BaseDocumentContext } from 'next/document';
import type { NextRouter, Router } from 'next/router';
import { ReactElement, ReactNode } from 'react';

import type { NormalizedCacheObject } from '@apollo/client';
import { YandexPayOptions } from '@server/config';
import { Experiments } from '@server/shared/experiments';

import { YEnv } from './env';

export interface Language {
  id: string;
  name: string;
}

export interface Viewer {
  uid?: string;
  avatarId: string;
  havePlus: boolean;
  plusBalance: string;
  isFamilyAdmin: boolean;
  publicId: string;
}

export interface Ua {
  isTouch?: boolean;
  isMobile?: boolean;
  mobileOsFamily?: 'android' | 'ios';
  isYandexApp?: boolean;
  browserVersion?: string;
  osVersion?: string;
  /**
   * Признак yandexApp контейнера.
   */
  isSearchApp?: boolean;
}

export interface NextPageContext extends BaseNextPageContext {
  req?: IncomingMessage & {
    nextBridge: NextBridge;
  };
}

export type NextAppContextType<R extends NextRouter = NextRouter> = {
  Component: NextComponentType<NextPageContext>;
  AppTree: BaseAppContext['AppTree'];
  ctx: NextPageContext;
  router: R;
};

export type IUiFlags = {
  additionalNavigation?: boolean;
};

export interface ServerSideProps {
  isYandexNet?: boolean;
  isYandexoid?: boolean;
  tld: string;
  reqid: string;
  version: string;
  yenv: YEnv;
  exp: Experiments;
  language: Language;
  viewer: Viewer;
  secretKey: string;
  ua: Ua;
  uiFlags: IUiFlags;
  yandexPayConfig: YandexPayOptions;
}

export interface NextBridge {
  getServerSideProps(context?: NextPageContext): Promise<ServerSideProps>;
  getNonce(): string;
  graphqlSchema: GraphQLSchema;
}

export type DocumentContext = BaseDocumentContext & NextPageContext;

export type DocumentRenderPage = DocumentContext['renderPage'];

export type NextAppContext = NextAppContextType<Router>;

export interface NextAppInitialProps {
  pageProps: any;
  serverSideProps: ServerSideProps;
  apolloState?: NormalizedCacheObject;
}

export interface LayoutEnhancer {
  getLayout?: (page: ReactElement) => ReactNode;
}

export interface NextAppPropsType<R extends NextRouter = NextRouter, P = {}>
  extends NextAppInitialProps {
  Component: NextComponentType<NextPageContext, any, P> & LayoutEnhancer;
  router: R;
  __N_SSG?: boolean;
  __N_SSP?: boolean;
  __N_RSC?: boolean;
}

export type NextAppProps<P = {}> = NextAppPropsType<Router, P>;

export type NextApp<P = {}, CP = {}> = NextComponentType<
  NextAppContext,
  NextAppInitialProps,
  P & NextAppProps<CP>
>;
