const path = require('path');
const fs = require('fs');

module.exports.readDirRecursive = function readDirRecursive(dir, subdir = '') {
  const items = fs.readdirSync(path.join(dir, subdir), { withFileTypes: true });
  const files = items.map((item) => {
    const res = path.join(subdir, item.name);

    return item.isDirectory() ? readDirRecursive(dir, res) : res;
  });

  return files.flat(Infinity);
};
