const { writeFileSync } = require('fs');
const { join } = require('path');

function init() {
  const { NEXT_VER, TRENDBOX_PULL_REQUEST_NUMBER, DEPLOY_SCRIPT_ENV } = process.env;
  const buildConfig = {
    version: NEXT_VER,
  };

  const PROJECT_NAME = 'yandex-id';

  switch (DEPLOY_SCRIPT_ENV) {
    case 'beta':
      buildConfig.staticPath = `${PROJECT_NAME}/pr-${TRENDBOX_PULL_REQUEST_NUMBER}/_next/static`;
      break;
    case 'testing':
      buildConfig.staticPath = `${PROJECT_NAME}/_/_next/static`;
      break;
    default:
      buildConfig.staticPath = '';
      break;
  }

  writeFileSync(join(__dirname, '../.build-config.json'), JSON.stringify(buildConfig), 'utf8');

  return;
}

init();
