const path = require('path');
const MergeIntoSingle = require('./webpack-merge-and-include-globally');

module.exports.rumEBBundlerConfig = function RumEBBundlerConfig(config, options) {
  if (options.isServer) {
    config.resolve.alias['@yandex-int/error-counter'] = false;
    config.resolve.alias['@yandex-int/rum-counter'] = false;

    return;
  }

  config.plugins.push(
    new MergeIntoSingle({
      files: [
        {
          src: [
            require.resolve('@yandex-int/rum-counter/dist/inline/interface.js'),
            require.resolve('@yandex-int/rum-counter/dist/inline/longtask.js'),
            require.resolve('@yandex-int/rum-counter/dist/inline/io.js'),
            require.resolve('@yandex-int/rum-counter/dist/bundle/send.js'),
            require.resolve('@yandex-int/error-counter/dist/interfaceOverRum.js'),
            require.resolve('@yandex-int/error-counter/dist/implementation.js'),
            require.resolve('@yandex-int/error-counter/dist/filters.min.js'),
            require.resolve('@yandex-int/error-counter/dist/logError.js'),
            require.resolve('@yandex-int/error-counter/dist/logAjaxError.js'),
            require.resolve(path.join(__dirname, '../../src/client/shared/libs/rum/inline-config')),
          ],
          dest: 'inline-rum-bundle.js',
        },
      ],
    }),
  );
};
