const {
    DOCKER_TOKEN,
    DCTL_YP_TOKEN,
    ROBOT_AWACS_TOKEN,
    ROBOT_CI_LOGIN,
    S3_STATIC,
} = process.env;

const useS3Static = S3_STATIC === '1';

module.exports = {
    scripts: {
        master: {
            workflow: 'createBeta',
            configPath: '.config/deploy/config.beta.yml',
            slug: 'master',
        },
        'update-rc': {
            workflow: 'applyRelease',
            configPath: '.config/deploy/config.rc.yml',
        },
    },
    options: {
        login: ROBOT_CI_LOGIN,
        dctlToken: DCTL_YP_TOKEN,
        awacsToken: ROBOT_AWACS_TOKEN,
        yavLogin: ROBOT_CI_LOGIN,
        docker: {
            registry: 'registry.yandex.net',
            repository: 'mail/ohio/frontend',
            login: ROBOT_CI_LOGIN,
            oauthToken: DOCKER_TOKEN,
            buildArgs: useS3Static ? ['--build-arg', 'S3_STATIC=1'] : [],
        },
    },
};
