const getBrowsers = require('./get-browsers');
const getConfig = require('./get-config');
const getPlugins = require('./get-plugins');

const desktopBrowsers = [
    'linux-chrome',
];
const touchBrowsers = [
    'appium-chrome-phone',
];

module.exports = {
    ...getConfig(),

    sets: {
        desktop: {
            files: [
                'tests/hermione/suites/common/**/*.hermione.js',
                'tests/hermione/suites/desktop/**/*.hermione.js',
            ],
            browsers: desktopBrowsers,
        },
        touch: {
            files: [
                'tests/hermione/suites/common/**/*.hermione.js',
                'tests/hermione/suites/touch/**/*.hermione.js',
            ],
            browsers: touchBrowsers,
        },
    },

    browsers: getBrowsers([
        ...desktopBrowsers,
        ...touchBrowsers,
    ]),

    plugins: getPlugins([
        'html-reporter',
        'hermione-image-minifier',
    ], {
        type: 'application',
    }),
};
