/**
 * Десктопный Chrome в Linux
 */
module.exports = () => ({
    desiredCapabilities: {
        browserName: 'chrome',
        version: '67.0',
        chromeOptions: {
            prefs: {
                credentials_enable_service: false,
                profile: {
                    default_content_setting_values: {
                        password_manager_enabled: false,
                    },
                },
                browser: {
                    enable_spellchecking: false,
                },
            },
        },
    },
    compositeImage: true,
    windowSize: '640x512',
    testsPerSession: 4,
    meta: {
        platform: 'desktop',
    },
});
