const path = require('path');

module.exports = () => ({
    gridUrl: 'http://frontend@sw.yandex-team.ru:80/v0',
    screenshotsDir: (test) => path.join(path.dirname(test.file), 'screens', test.id(), test.browserId),
    antialiasingTolerance: 4,
    saveHistoryOnTestTimeout: true,
    saveHistoryOnError: true,
    sessionsPerBrowser: 8,
    compareOpts: {
        shouldCluster: true,
    },
    system: {
        workers: 4,
        mochaOpts: {
            timeout: 60000,
        },
        patternsOnReject: [
            /timeout/i,
            /timedout/i,
            /timed out/i,
            /It may have died/,
            /CLIENT_STOPPED_SESSION/,
            /was terminated due to CLIENT_GONE/,
            /cannot forward the request/,
            /FORWARDING_TO_NODE_FAILED/,
            /PROXY_REREGISTRATION/,
            /not available and is not among the last/,
            /ESOCKETTIMEDOUT/,
        ],
    },
});
