const fs = require('fs');
const path = require('path');

/**
 * @param {String} directoryPath
 */
module.exports = (directoryPath) => {
    directoryPath = path.resolve(directoryPath);

    const directoryMap = new Map();

    for (const dirent of fs.readdirSync(directoryPath, { withFileTypes: true })) {
        if (!dirent.isFile()) {
            continue;
        }

        const filename = dirent.name;
        const extname = path.extname(filename);

        if (extname !== '.js') {
            continue;
        }

        const basename = path.basename(filename, extname);

        directoryMap.set(basename, require(path.join(directoryPath, filename)));
    }

    return (names, options = {}) => {
        const result = {};

        for (const name of names) {
            const executor = directoryMap.get(name);

            result[executor.fullname || name] = executor(options);
        }

        return result;
    };
};
