const getPortSync = require('get-port-sync');

const getBrowsers = require('./get-browsers');
const getConfig = require('./get-config');
const getPlugins = require('./get-plugins');
const prepareBrowser = require('./prepare-browser');

const desktopBrowsers = [
    'linux-chrome',
];

module.exports = {
    ...getConfig(),

    sets: {
        desktop: {
            files: [
                'src/client/components/*/*.tests/*.hermione.js',
                'src/client/screens/**/*.tests/*.hermione.js',
            ],
            browsers: desktopBrowsers,
        },
    },

    browsers: getBrowsers(desktopBrowsers),

    plugins: getPlugins([
        'html-reporter',
        'hermione-image-minifier',
        'tunneler',
        'http-server-runner',
    ], {
        localPort: getPortSync(),
        type: 'storybook',
    }),

    prepareBrowser: prepareBrowser([
        'openComponent',
    ]),
};
