const restrictedGlobals = require('confusing-browser-globals');

module.exports = {
    rules: {
        '@typescript-eslint/no-explicit-any': 'warn',
        '@typescript-eslint/no-inferrable-types': 'warn',
        '@typescript-eslint/no-empty-interface': 'warn',
        'prettier/prettier': 'off',
        '@typescript-eslint/no-empty-function': 'warn',
    },
    overrides: [
        {
            files: ['**/i18n/**/*.ts'],
            rules: {
                'ascii/valid-name': 'off',
            },
        },
        {
            files: ['**/sw.ts'],
            rules: {
                'no-restricted-globals': ['error'].concat(
                    restrictedGlobals.filter((item) => item !== 'self'),
                ),
            },
        },
    ],
};
