const AUTOFIX = process.env.AUTOFIX;

module.exports = {
    './src/server/*.ts': AUTOFIX ? [] : [() => 'tsc -p ./tsconfig.server.json --noEmit'],
    './src/*.ts': AUTOFIX ? [] : [() => 'tsc -p ./tsconfig.json --noEmit'],
    './src/(client|root)/**/*.ts{,x}': AUTOFIX
        ? []
        : [() => 'tsc -p ./tsconfig.client.json --noEmit'],
    './src/client/**/*.{,s}css': AUTOFIX ? ['stylelint --fix'] : ['stylelint'],
    './**/*.{{j,t}s{,x},json}': AUTOFIX ? ['eslint --fix'] : ['eslint'],
    './.*.{{j,t}s{,x},json}': AUTOFIX ? ['eslint --fix'] : ['eslint'],
    './*.{,s}css': ['stylelint'],
    './src/client/**/*.svg': ['svgo'],
};
