import { Story } from '@storybook/react';
import { StoryFnReactReturnType } from '@storybook/react/dist/client/preview/types';
import * as React from 'react';

export const TemplateFactory = <P,>(Component: (props: P) => StoryFnReactReturnType | null) => (
    props: Partial<P>,
): Story<P> => {
    const template: Story<P> = (args: P) => {
        return <Component {...args} />;
    };

    const story = template.bind({});

    story.args = props;

    return story;
};
