const webpackConfig = require('../webpack.config');

module.exports = {
    stories: ['../src/client/**/*.stories.tsx'],
    addons: ['@storybook/addon-links', '@storybook/addon-essentials'],
    typescript: {
        reactDocgenTypescriptOptions: {
            tsconfigPath: '../tsconfig.client.json',
        },
    },
    webpackFinal: async (config, { configType }) => {
        // `configType` has a value of 'DEVELOPMENT' or 'PRODUCTION'
        // You can change the configuration based on that.
        // 'PRODUCTION' is used when building the static version of storybook.

        // Make whatever fine-grained changes you need

        const rules = [
            {
                test: /\.svg$/,
                issuer: /\.tsx?$/,
                exclude: /node_modules/,
                use: [
                    {
                        loader: 'file-loader',
                        options: {
                            publicPath: './_/',
                            outputPath: './_',
                            name: 'fl.[contenthash].[ext]',
                        },
                    },
                ],
            },
        ];

        const base = webpackConfig({ server: false, analyze: false, production: false });

        Object.assign(config.resolve, base.resolve);
        config.plugins.push(...base.plugins);
        config.module.rules = config.module.rules.slice(0, -3).concat(base.module.rules);

        config.module.rules = config.module.rules.filter((rule) => `${rule.test}` !== '/\\.svg$/');
        config.module.rules.push(...rules);

        // Return the altered config
        return config;
    },
};
