const { langs } = require('./common');

const dispatcher = require.resolve('./dispatcher');
const parser = require.resolve('./parser.js');

module.exports = config => {
    if (!process.env.TANKER_TOKEN) {
        throw 'Enviroment variable TANKER_TOKEN is empty';
    }
    
    const levels = [
        'src/client/translations',
        'src/client/components',
        'src/client/screens',
        'src/client/App',
    ];

    config.finders = [
        'find ' +
        levels.join(' ') +
        ' -name "*.ts" -o -name "*.tsx"'
    ];

    config.tanker.project = 'order-history-frontend';
    config.tanker.langs = langs;
    config.tanker.default = 'ru';
    config.tanker.branch = 'master';
    config.tanker.token = process.env.TANKER_TOKEN;
    config.tanker.force = true;
    config.parsers.ts = parser;
    config.parsers.tsx = parser;
    config.dispatchers.json = dispatcher;

    config.bemDispatcher = {
        levelResolver: () => 'src/client/i18n'
    };
};
