const path = require('path');
const reactDispatcher = require('tanker-kit/ext/dispatchers/json2bem_serp');
const { I18nKeysetHandler, I18nKeysetHandlerStorage } = require('@yandex-int/tanker-helpers/dispatchers/ts-keyset');

class CustomI18nKeysetHandler extends I18nKeysetHandler {
    getPath() {
        return path.join(`${this.dir}.i18n`, `${this.lang}.ts`);
    }

    getIndexPath() {
        return path.join(`${this.dir}.i18n`, 'index.ts');
    }
}

module.exports = function(arg) {
    /**
     * в i18nKeysets приходит объект вида:
     * {
     *   "src/Foo/Foo.server.tsx-i18n/ru.js": "module.exports = { "Foo": { ... } };",
     *   ...
     * }
     */
    return reactDispatcher(arg).then(i18nKeysets => {
        const i18nStorage = new I18nKeysetHandlerStorage();

        for (const [filePath, fileContent] of Object.entries(i18nKeysets)) {
            i18nStorage.add(new CustomI18nKeysetHandler(filePath, fileContent));
        }

        return i18nStorage.getFiles();
    });
};
