require('dns-graceful-stack-switch')(6);
require('dnscache')({
    enable: true,
    ttl: 300,
    cachesize: 1000,
});

const express = require('express');

const app = express();

const rebuild = () => {
    try {
        require('./build/server').default(app);
    } catch (e) {
        if (process.env.NODE_ENV === 'development' && e.code === 'MODULE_NOT_FOUND') {
            // eslint-disable-next-line no-console
            console.log(e);

            return setTimeout(rebuild, 3000);
        }

        throw e;
    }
};

rebuild();

module.exports = app;
