const { resolve } = require('path');

const autoprefixer = require('autoprefixer');
const cssnano = require('cssnano');
const postcssCustomProperties = require('postcss-custom-properties');
const postcssFlexbugsFixes = require('postcss-flexbugs-fixes');
const themeFold = require('postcss-theme-fold');

module.exports = {
    plugins: [
        autoprefixer({
            flexbox: 'no-2009',
        }),
        postcssFlexbugsFixes(),
        cssnano({
            preset: [
                'default',
                {
                    discardComments: {
                        removeAll: true,
                    },
                },
            ],
        }),
        postcssCustomProperties({
            importFrom: resolve('src/client/App/index.css'),
            preserve: true,
        }),
        themeFold({
            themes: [
                [
                    resolve('node_modules/@yandex-lego/components/Theme/presets/default.css'),
                    resolve('src/client/App/index.css'),
                ],
            ],
        }),
    ],
};
