const fs = require('fs');
const path = require('path');

const { transformFileSync } = require('@babel/core');
const { injectManifest } = require('workbox-build');

const { bucket, service } = require('../.config/static');
const { version } = require('../package.json');

const DEV = process.argv.includes('--dev');
const SERVER = process.argv.includes('--server');
const PROJECT_BASE = '/order-history/';
const STATIC_BASE = DEV ? PROJECT_BASE + 'assets/' : `https://yastatic.net/s3/${bucket}/${service}/`;

if (SERVER) {
    fs.writeFileSync(
        path.resolve(__dirname, '../public/sw.js'),
        transformFileSync(path.resolve(__dirname, '../src/server/sw.ts')).code.replace(
            'self.__PATH',
            `'${STATIC_BASE}${DEV ? '' : `v${version}/`}sw.js'`,
        ),
    );
} else {
    injectManifest({
        swSrc: 'src/client/sw.ts',
        swDest: 'public/assets/sw.js',
        globPatterns: ['**/*.{js,css,svg,html}'],
        globDirectory: path.resolve(__dirname, 'public/assets'),
        maximumFileSizeToCacheInBytes: DEV ? 100 * 1024 * 1024 : undefined,
        dontCacheBustURLsMatching: /\w+\.[\w\d]+\.\w{2,4}$/,
        additionalManifestEntries: [
            {
                url: PROJECT_BASE + 'index.html',
                revision: '__UPDATE__',
            },
        ],
        manifestTransforms: [
            (r) => ({
                manifest: r.map((item) => ({
                    ...item,
                    url: `${STATIC_BASE}${item.url}`,
                })),
            }),
        ],
    }).then(({ filePaths: [filePath] }) => {
        const tsFilePath = filePath.slice(0, -2) + 'ts';

        fs.renameSync(filePath, tsFilePath);
        fs.writeFileSync(filePath, transformFileSync(tsFilePath).code);
        fs.unlinkSync(tsFilePath);
    });
}
