const fs = require('fs');
const https = require('https');
const path = require('path');

const sh = require('shelljs');

const version = require('../.config/archon/lib/get-version');

const getPath = (filePath) => path.resolve(__dirname, '../', filePath);

sh.sed('-i', /{{VERSION}}/g, version, getPath('build/server/config/common.js'));

https.get(`https://yastatic.net/s3/passport-static/order-history/v${version}/loadable-stats.json`, (res) => {
    res.pipe(fs.createWriteStream(getPath('build/loadable-stats.json')));
});
