import i18nFactory from '@i18n';
import * as keyset from '@i18n/ErrorBoundary.i18n';
import React, { useCallback } from 'react';

import { i18nCommon } from '@client/translations/common';
import { i18nError } from '@client/translations/error';
import Button from '@components/Button';
import Error from '@components/Error';
import Page from '@components/Page';

import styles from './index.module.css';

const i18n = i18nFactory(keyset);

const ErrorBoundaryContent = () => {
    const reload = useCallback(() => {
        window.location.reload();
    }, []);

    return (
        <Page>
            <Error
                title={i18n('Упс') + '...'}
                subtitle={i18nError('somethingWentWrong')}
                className={styles['error-boundary']}
                description={
                    <>
                        {i18n('Не очень понятно, что произошло, кажется, какая-то сложная ошибка.')}
                        <br />
                        {i18n('Иногда помогает перезагрузка.')}
                    </>
                }
                action={
                    <Button size="l" view="action" onClick={reload}>
                        {i18nCommon('reloadPage')}
                    </Button>
                }
            />
        </Page>
    );
};

export default ErrorBoundaryContent;
