import React, { useMemo } from 'react';
import { Switch, Route, Redirect, useLocation } from 'react-router-dom';

import { GibddScreenRoute } from '@client/screens/GibddScreen';
import PenaltyDetailsRoute from '@client/screens/GibddScreen/Details/PenaltyDetailsRoute';
import MainScreen from '@client/screens/MainScreen';
import OrderDetailsRoute from '@client/screens/MainScreen/OrdersDetails/OrderDetailsRoute';
import useConstants from '@hooks/useConstants';
import { getRoutes } from '@src/routes';

const Navigator: React.FC = () => {
    const { baseUrl } = useConstants();
    const { state } = useLocation<{ path: string; props: ANY; } | undefined>();
    const routes = useMemo(() => getRoutes(baseUrl), [baseUrl]);
    const stateLocation = useMemo(() => {
        if (!state || !state.path) {
            return {
                key: '',
                state: {
                    props: undefined,
                },
                pathname: '',
                hash: '',
                search: '',
            };
        }

        return {
            key: state.path,
            state: {
                props: state.props,
            },
            pathname: state.path,
            hash: '',
            search: '',
        };
    }, [state]);

    return (
        <>
            <Switch>
                <Route path={routes.gibdd}>
                    <GibddScreenRoute />
                </Route>

                <Route path={routes.main}>
                    <MainScreen />
                </Route>

                <Route path="*">
                    <Redirect to="/" />
                </Route>
            </Switch>
            <Switch location={stateLocation}>
                <Route path="/order" component={OrderDetailsRoute} />
                <Route path="/penalty" component={PenaltyDetailsRoute} />
                <Route path="/bills/documents" component={PenaltyDetailsRoute} />
            </Switch>
        </>
    );
};

export default Navigator;
