import i18nFactory from '@i18n';
import * as keyset from '@i18n/Main.i18n';
import React, { useState, useCallback } from 'react';

import { i18nCommon } from '@client/translations/common';
import Button from '@components/Button';
import Modal from '@components/Modal';

import styles from './index.module.css';

const i18n = i18nFactory(keyset);

const PwaWarningModal = () => {
    const [visible, setVisibility] = useState(true);
    const onClose = useCallback(() => setVisibility(false), []);

    return (
        <Modal visible={visible} onClose={onClose}>
            <div className={styles.modal}>
                <span>
                    {i18n('Внимание! Вы сейчас в оффлайн режиме. Контент может быть устаревшим.')}
                </span>
                <div className={styles.action}>
                    <Button view="action" size="s" onClick={onClose}>
                        {i18nCommon('ok')}
                    </Button>
                </div>
            </div>
        </Modal>
    );
};

export default PwaWarningModal;
