import React from 'react';

import useConstants from '@hooks/useConstants';
import { canUseDom } from '@use-platform/react/libs/dom-utils';
// @ts-expect-error
import * as UserHTML from '@yandex-lego/serp-header/dist/base/user2.desktop';
import { getStaticPath } from '@yandex-lego/serp-header/staticPath';

export const User: React.FC = React.memo(() => {
    const { authInfo, lang, tld, platform, config, nonce } = useConstants();

    const { uid, yu, name, avatarId, hasPlus } = authInfo?.user || {};

    const user = UserHTML.getContent({
        tld,
        lang,
        nonce,
        ctx: {
            uid,
            yu,
            name,
            avatarId,
            avatarHost: config.avatarHost,
            hasPlus,
            platform: platform.isMobile ? 'touch-phone' : 'desktop',
            accountsUrl: `https://api.${config.passportHost}/all_accounts`,
            retpath: `https://${config.passportHost}/order-history`,
        },
    });

    React.useEffect(() => {
        if (canUseDom) {
            const script = document.createElement('script');

            script.src = getStaticPath({
                key: 'base',
                platform: 'desktop',
                block: 'user2',
                service: 'base',
            });
            document.body.appendChild(script);
        }
    }, []);

    return <div dangerouslySetInnerHTML={{ __html: user }} />;
});
