import React, { useMemo } from 'react';
import { Provider as StoreProvider } from 'react-redux';

import { createStore } from '@client/redux';
import { ConstantsProvider } from '@hooks/useConstants/context';
import { MetrikaProvider } from '@hooks/useMetrika/context';
import { ErrorsContextProvider } from '@lib/errors';
import type { RenderProps } from '@src/types';

const Wrapper: React.FC<RenderProps> = ({ state, metrika, children, constants }) => {
    const store = useMemo(() => createStore(state), [state]);

    return (
        <ErrorsContextProvider>
            <StoreProvider store={store}>
                <ConstantsProvider value={constants}>
                    <MetrikaProvider value={metrika}>{children}</MetrikaProvider>
                </ConstantsProvider>
            </StoreProvider>
        </ErrorsContextProvider>
    );
};

export default Wrapper;
