import { useEffect, useCallback } from 'react';

import { useDispatch } from '@client/hooks/redux';

const useNetStateChange = () => {
    const dispatch = useDispatch();
    const setOffline = useCallback((isOffline: boolean) => dispatch({ type: 'SET_OFFLINE', isOffline }), [dispatch]);

    useEffect(() => {
        const handleOnline = () => setOffline(false);
        const handleOffline = () => setOffline(true);

        setOffline(!((navigator || {}).onLine ?? true));
        window.addEventListener('online', handleOnline);
        window.addEventListener('offline', handleOffline);

        return () => {
            window.removeEventListener('online', handleOnline);
            window.removeEventListener('offline', handleOffline);
        };
    }, [setOffline]);
};

export default useNetStateChange;
