declare module '*.css' {
    const classNames: Record<string, string>;
    export default classNames;
}

declare module '*.svg' {
    const data: string;
    export default data;
}

declare const __DEV__: boolean;
declare const __SERVER__: boolean;

interface Window {
    __CSRF__: string;
    __FONT_LOADED__: boolean;
    __STATE__: import('../types').State;
    __REDUX_DEVTOOLS_EXTENSION__?: Function;
    __CONSTANTS__: import('../types').Constants;
    __INITIAL_SSR_ERROR_META__?: import('../types').InitialSsrErrorMeta;
    chatWidget: {
        hideChat: () => void;
        showChat: (options: {
            guid?: string;
            chatId?: string;
            pasteText?: string;
            inviteHash?: string;
            pasteForce?: boolean;
            anchorTimestamp?: number;
        }) => void;
    };
    Ya: Ya;
    YaPay: import('./types/yandex-pay').YaPay & {
        createPayment: import('./types/yandex-pay').createPayment;
    };
}

declare namespace Client {
    type StatusOrder = string | 'paid' | 'created' | 'refunded' | 'cancelled' | 'advance';

    type PaymentMethod =
        | 'card'
        | 'yamoney_wallet'
        | 'compensation'
        | 'cash'
        | 'new_promocode'
        | 'composite'
        | 'virtual::kinopoisk_card_discounts'
        | 'virtual::kinopoisk_subs_discounts'
        | 'virtual::new_promocode'
        | 'spasibo'
        | 'spasibo_cashback'
        | 'afisha_fake_refund'
        | 'yandex_account_withdraw'
        | 'yandex_account_topup'
        | 'afisha_certificate'
        | 'credit'
        | 'google_pay'
        | 'apple_pay'
        | string;

    type Price = number;
}

type Nullable<T> = T | null;
