import React, { useCallback } from 'react';
import { useHistory } from 'react-router';

import { i18nCommon } from '@client/translations/common';

import Icon from '../Icon';

type Props = {
    className?: string;
};

const BackButton = ({ className }: Props) => {
    const history = useHistory();

    const handleClick = useCallback(() => {
        // @ts-expect-error
        history.goBack();
    }, [history]);

    return (
        <Icon
            size="s"
            name="arrowleft"
            onClick={handleClick}
            className={className}
            alt={i18nCommon('backwards')}
        />
    );
};

export default BackButton;
