import React from 'react';

import { compose, composeU } from '@bem-react/core';
import {
    withSizeS,
    withSizeM,
    withSizeL,
    withTypeLink,
    withWidthMax,
    withViewClear,
    withViewAction,
    withViewDefault,
    withPinCircleCircle,
    IButtonProps,
    IButtonSizeSProps,
    IButtonSizeMProps,
    IButtonSizeLProps,
    IButtonTypeLinkProps,
    IButtonWidthMaxProps,
    IButtonViewClearProps,
    IButtonViewActionProps,
    IButtonViewDefaultProps,
    IButtonPinCircleCircleProps,
    withTypeSubmit,
    IButtonTypeSubmitProps,
} from '@yandex-lego/components/Button/desktop';
import { Button as LegoButton } from '@yandex-lego/components/Button/desktop';

import { withPinRoundM, IButtonPinRoundMProps } from './_pin/_round-m/Button_pin_round-m';
import { withSizeXl, IButtonSizeXlProps } from './_size/_xl/Button_size_xl';
import styles from './index.module.css';

const ComposedLegoButton = compose(
    composeU(
        withSizeS,
        withSizeM,
        withSizeL,
        withSizeXl,
    ),
    composeU(
        withTypeLink,
        withTypeSubmit,
    ),
    withWidthMax,
    composeU(
        withViewClear,
        withViewAction,
        withViewDefault,
    ),
    composeU(
        withPinCircleCircle,
        withPinRoundM,
    ),
)(LegoButton);

type SizeProps =
    IButtonSizeSProps |
    IButtonSizeMProps |
    IButtonSizeLProps |
    IButtonSizeXlProps;

type ViewProps =
    IButtonViewClearProps |
    IButtonViewActionProps |
    IButtonViewDefaultProps;

type TypeProps = IButtonTypeLinkProps | IButtonTypeSubmitProps;

type PinProps = IButtonPinCircleCircleProps | IButtonPinRoundMProps;

type Props =
    IButtonProps &
    SizeProps &
    TypeProps &
    IButtonWidthMaxProps &
    ViewProps &
    PinProps;

const Button = ({ ...rest }: Props) => (
    <ComposedLegoButton className={styles.button} {...rest} />
);

export { LegoButton };

export default Button;
