import React from 'react';

import { cn } from '@bem-react/classname';
import { IClassNameProps } from '@bem-react/core';

import Button from '@components/Button';
import Icon from '@components/Icon';
import type { Icons, Theme } from '@components/Icon/assets';
import useMetrika from '@hooks/useMetrika';

import './index.css';

const cnButtonLink = cn('ButtonLink');

interface Props extends IClassNameProps {
    link?: string;
    onClick?: () => void;
    text: string;
    icon?: Icons[Theme];
    metrika?: string | object;
}

const ButtonLink: React.FC<Props> = ({ link, onClick, text, icon, metrika: metrikaParam, className }) => {
    const metrika = useMetrika();

    const handleClick = React.useCallback(() => {
        if (!metrikaParam) {
            return;
        }

        metrika.params({
            click_button_card: metrikaParam,
        });
    }, [metrika, metrikaParam]);

    return (
        <a href={link} target="_blank" onClick={handleClick} className={cnButtonLink(null, [className])} rel="noreferrer">
            <Button className={cnButtonLink('Button')} view="default" size="m" width="max" onClick={onClick} pin="circle-circle">
                <div className={cnButtonLink('Content')}>
                    {icon ? <Icon name={icon} size="s" /> : null}
                </div>
            </Button>
            <span className={cnButtonLink('Text')}>{text}</span>
        </a>
    );
};

export default ButtonLink;
