import Card from './index';

import 'yandex-font/build/browser.css';
import { TemplateFactory } from '../../../../.storybook/helpers/TemplateFactory';

export default {
    title: 'Component/Card',
    component: Card,
    argTypes: {},
    args: {
        serviceName: 'Яндекс.Афиша',
        icon: 'https://yastatic.net/s3/chat-static/favicons/favicon-180.png',
        description: '1 билет',
        price: -4500,
        plus: 450,
        currency: 'RUB',
    },
};

const template = TemplateFactory(Card);

export const Default = template({});

export const WithoutDescription = template({ description: undefined });

export const WithoutPlus = template({ plus: undefined });

export const PaidPlus = template({ plus: -150 });

export const WithoutPrice = template({ price: undefined });

export const WithStatusRefunded = template({
    plus: undefined,
    price: 1500,
    status: 'refunded',
});

export const RefundedPlus = template({
    plus: 10,
    price: undefined,
    status: 'refunded',
});

export const RefundedNegativePlus = template({
    plus: -10,
    price: undefined,
    status: 'refunded',
});

export const WithStatusCancelled = template({
    plus: undefined,
    status: 'cancelled',
});

export const WithStatusAdvance = template({
    status: 'advance',
});

export const WithCashback = template({
    cashback: 35,
});

export const LongText = template({
    serviceName: 'Яндекс.АфишаЯндекс.АфишаЯндекс.АфишаЯндекс.АфишаЯндекс.АфишаЯндекс.АфишаЯндекс.АфишаЯндекс.Афиша',
    description: '1 билет1 билет1 билет1 билет1 билет1 билет1 билет1 билет1 билет1 билет1 билет1 билет1 билет1 билет',
});

export const FamilyPayment = template({
    initiatorAvatar: '//avatars.mdst.yandex.net/get-yapic/1824/SpilA8dV7VClkcTgd3Fuwslx7M-1/islands-retina-middle',
    initiatorName: 'Инокентий',
});
