import i18nFactory from '@i18n';
import * as keyset from '@i18n/CashbackShortcut.i18n';
import React from 'react';

import { IClassNameProps } from '@bem-react/core/core';

import { formatCurrency } from '@client/helpers/number';
import { Shortcut } from '@yandex-id/components';
import useConstants from '@hooks/useConstants';
import { useReceiptsConnect } from '@hooks/useReceiptsConnect';

const i18n = i18nFactory(keyset);

export const CashbackShortcut: React.FC<IClassNameProps> = ({ className }) => {
    const { fnsData } = useConstants();
    const { isBind, amount = 0 } = fnsData || {};
    const { url, onConnectClick } = useReceiptsConnect('click_shortcut_receipts');

    const label = isBind ? i18n('Кешбэк') : i18n('Мои чеки');
    const text = isBind ? i18n('Найти товары с кешбэком') : i18n('Кешбэк за покупки в магазинах');
    const buttonText = !isBind ? i18n('Хочу кешбэк') : undefined;

    return (
        <Shortcut
            className={className}
            size={isBind ? 's' : 'l'}
            href={!isBind ? url : 'https://edadeal.ru/cashbacks'}
            referrerPolicy="unsafe-url"
            onPress={onConnectClick}
            amount={isBind ? String(amount) : undefined}
            amountIcon="coins"
            currency={formatCurrency('RUB')}
            label={label}
            target="_blank"
            text={text}
            variant="edadeal"
            labelBold={isBind}
            textBold={!isBind}
            withImage={!isBind}
            buttonText={buttonText}
        />
    );
};
