import React from 'react';

import { classnames } from '@bem-react/classnames';

import { isStrictDefined } from '@src/helpers';

import styles from './index.module.css';

import { formatPrice } from '../../helpers/number';

interface Props {
    value?: number;
    mode?: 'small' | 'medium' | 'large';
    refunded?: boolean;
}

const CashbackValue: React.FC<Props> = ({ value, mode = 'small' }) => {
    if (!isStrictDefined(value) || value === null) {
        return null;
    }

    return (
        <div className={classnames(styles.container, styles[mode])}>
            {formatPrice(value, 'RUB', true, { signed: true })}
        </div>
    );
};

export default CashbackValue;
