import React from 'react';

import { compose, composeU } from '@bem-react/core';
import {
    withSizeS,
    withSizeM,
    ICheckboxProps,
    ICheckboxSizeSProps,
    ICheckboxSizeMProps,
    ICheckboxViewDefaultProps,
    withViewDefault,
    withViewOutline,
    ICheckboxViewOutlineProps,
} from '@yandex-lego/components/Checkbox/desktop';
import { Checkbox as LegoCheckbox } from '@yandex-lego/components/Checkbox/desktop';

import { withVariantYellow, ICheckboxVariantYellowProps } from './_variant/_yellow/Checkbox_variant_yellow';

const ComposedLegoCheckbox = compose(
    composeU(
        withSizeS,
        withSizeM,
    ),
    composeU(
        withViewDefault,
        withViewOutline,
    ),
    composeU(
        withVariantYellow,
    ),
)(LegoCheckbox);

type SizeProps =
    ICheckboxSizeSProps |
    ICheckboxSizeMProps;

type ViewProps =
    ICheckboxViewDefaultProps |
    ICheckboxViewOutlineProps;

type VariantProps =
    ICheckboxVariantYellowProps;

type Props =
    ICheckboxProps &
    SizeProps &
    VariantProps &
    ViewProps;

const Checkbox = ({ ...rest }: Props) => (
    <ComposedLegoCheckbox {...rest} />
);

export { LegoCheckbox };

export default Checkbox;
