import React from 'react';

import styles from './index.module.css';

interface Props {
    renderHeader(): Nullable<React.ReactElement>;
    renderInfo?(): Nullable<React.ReactElement>;
    renderFooter?(): Nullable<React.ReactElement>;
}

const DetailLayout: React.FC<Props> = ({ renderHeader, renderInfo, renderFooter }) => {
    return (
        <div className={styles.layout}>
            <div className={styles.header}>{renderHeader()}</div>
            {renderInfo ? (
                <div className={styles.info__container}>
                    <div className={styles.info}>{renderInfo()}</div>
                </div>
            ) : null}
            {renderFooter ? (
                <div className={styles.footer}>
                    {renderFooter()}
                </div>
            ) : null}
        </div>
    );
};

export default DetailLayout;
