import React from 'react';

import Drawer from '@components/Drawer';
import Modal from '@components/Modal';
import useConstants from '@hooks/useConstants';

import styles from './index.module.css';

interface Props {
    onClose?(): void;
}

const DetailPage: React.FC<Props> = ({ children, onClose }) => {
    const { platform } = useConstants();
    const { isMobile } = platform || {};

    if (isMobile) {
        return (
            <Drawer visible onClose={onClose}>
                {children}
            </Drawer>
        );
    }

    return (
        <Modal visible className={styles.modal} onClose={onClose} autoFocus={false}>
            {children}
        </Modal>
    );
};

export default DetailPage;
