import React from 'react';

import { compose } from '@bem-react/core';
import { Drawer as LegoDrawer, IDrawerProps } from '@yandex-lego/components/Drawer/touch-phone/bundle';
import { cnTheme } from '@yandex-lego/components/Theme';
import { theme } from '@yandex-lego/components/Theme/presets/default';
import { withZIndex, IWithZIndexProps } from '@yandex-lego/components/withZIndex';

import styles from './index.module.css';

const animationDrawer = {
    tension: 230,
    friction: 24,
};

const ComposedLegoDrawer = compose(withZIndex)(LegoDrawer);

type Props = IDrawerProps & IWithZIndexProps;

const Drawer: React.FC<Partial<Props>> = ({ className, children, ...props }) => (
    <ComposedLegoDrawer {...props} className={styles.drawer} view="default" animation={animationDrawer}>
        <div className={cnTheme(theme)}>{children}</div>
    </ComposedLegoDrawer>
);

export default Drawer;
