import i18nFactory from '@i18n';
import * as keyset from '@i18n/DropDownList.i18n';
import React, { useCallback, useMemo } from 'react';
import type { ReactNode } from 'react';

import { cn } from '@bem-react/classname';

import './index.css';

const cnDropDownList = cn('DropDownList');

const i18n = i18nFactory(keyset);

interface Props {
    count: number;
    data: ReactNode[];
}

const DropDownList: React.FC<Props> = ({ count, data }) => {
    const [isOpened, setIsOpened] = React.useState(false);

    const toggle = useCallback(() => {
        setIsOpened((wasOpened) => !wasOpened);
    }, [setIsOpened]);

    const countUpdated = useMemo(() => data.length - 1 > count ? count : count + 1, [data]);

    return (
        <div>
            {data && data.map((data, i) => (
                ((i < countUpdated) || (isOpened)) && data
            ))}

            {!isOpened && data && data.length > countUpdated && data.slice(0, countUpdated) ? (
                <div className={cnDropDownList('ShowMore')} onClick={toggle}>
                    {i18n('Показать еще {count}', { count: data.length - countUpdated })}
                </div>
            ) : null}

        </div>
    );
};

export default DropDownList;
