import i18nFactory, { i18nRaw as i18nRawFactory } from '@i18n';
import * as keyset from '@i18n/EdadealLanding.i18n';
import React from 'react';

import { classnames } from '@bem-react/classnames';
import { IClassNameProps } from '@bem-react/core';

import Button from '@components/Button';
import { useReceiptsConnect } from '@hooks/useReceiptsConnect';

import { Divider } from './Divider';
import styles from './index.module.css';
import { Spoiler } from './Spoiler';

const PARTNERS = ['ashan', 'mcdonalds', 'diksy', 'market', 'perekrestok', 'ozon', 'lenta'];

const i18n = i18nFactory(keyset);
const i18nRaw = i18nRawFactory(keyset);

interface ILinkProps extends IClassNameProps {
    href?: string;
}

const Link: React.FC<ILinkProps> = ({ children, href }) => {
    return (
        <a className={styles.link} href={href} target="_blank" rel="noreferrer">{children}</a>
    );
};

export const EdadealLanding = () => {
    const { url, onConnectClick } = useReceiptsConnect('click_receipt_landing_banner');

    return (
        <section className={styles.container}>
            <div className={styles.block}>
                <h2 className={styles.headerTitle}>
                    {i18n('Получайте кешбэк за{nbsp}покупки', { nbsp: '\u00A0' })}
                </h2>
                <p className={styles.description}>
                    {i18n('Все чеки будут сохраняться в истории платежей, а{nbsp}мы начислим кешбэк', { nbsp: '\u00A0' })}
                </p>
                <Button
                    className={styles.button}
                    size="m"
                    view="action"
                    type={url ? 'link' : undefined}
                    url={url}
                    target="_blank"
                    onClick={onConnectClick}>
                    {i18n('Хочу кешбэк')}
                </Button>
            </div>
            <div className={styles.block}>
                <h3 className={styles.title}>
                    {i18n('Зачем сохранять чеки?')}
                </h3>
                <div className={styles.promo}>
                    <div className={classnames(styles.image, styles.image_type_receipt)} />
                    <p className={styles.text}>
                        {i18nRaw('Если в чеке будут {link}, вы получите вознаграждение.', {
                            link: <Link href="https://edadeal.ru/cashbacks">{i18n('товары из списка кешбэк-акций')}</Link>,
                        })}
                    </p>
                </div>
                <Divider />
                <div className={classnames(styles.promo, styles.promo_align_center)}>
                    <div className={classnames(styles.image, styles.image_type_bag)} />
                    <p className={styles.text}>
                        {i18n('Вы всегда сможете найти где, что{nbsp}и{nbsp}когда покупали в{nbsp}истории платежей.', { nbsp: '\u00A0' })}
                    </p>
                </div>
                <div className={styles.partners}>
                    {PARTNERS.map((item) => (
                        <span key={item} className={classnames(styles.partner, styles['partner_' + item])} />
                    ))}
                </div>
                <Divider />
                <div className={styles.promo}>
                    <div className={classnames(styles.image, styles.image_type_shop)} />
                    <p className={styles.text}>
                        {i18n('Пригодится при обмене или возврате: электронный чек является подтверждением вашей покупки, как и бумажный.')}
                    </p>
                </div>
            </div>
            <div className={styles.block}>
                <h3 className={styles.title}>
                    {i18n('Остались вопросы?')}
                </h3>
                <Spoiler className={styles.spoiler} summary={i18n('Как мои чеки попадут в историю платежей?')}>
                    {i18n('При регистрации укажите номер телефона и почту, которые используете для покупок и регистрации карт лояльности. Сделайте покупку. При оформлении заказа укажите те же данные или используйте карту лояльности. В течение 24 часов чек с вашей покупкой появится в Яндекс ID.')}
                </Spoiler>
                <Spoiler className={styles.spoiler} summary={i18n('Я получу доступ ко всем своим чекам?')}>
                    {i18n('Будут доступны только те чеки, которые были получены после подключения к сервису «Мои чеки онлайн». Более ранние чеки не попадут в историю. Электронные чеки выдают более 10 000 организаций в России: сервисы Яндекса, популярные интернет-магазины, мобильные операторы, торговые сети, интернет-провайдеры, доставщики еды, сервисы по прокату и аренде, и многие другие.')}
                </Spoiler>
                <Spoiler className={styles.spoiler} summary={i18n('Можно ли получать чеки из оффлайн магазинов?')}>
                    {i18nRaw('На данный момент электронные чеки выдают в Пятерочке, Перекрестке, ВкусВилле, аптеках Неофарм и в некоторых других крупных торговых сетях. Для получения чеков от этих продавцов необходимо включить специальную опцию в личном кабинете в приложении торговой сети и использовать карту лояльности при покупке. Оффлайн магазинов, где есть возможность отправить чек в электронном виде, постепенно становится всё больше. Вы можете посмотреть актуальный список по {link}.', {
                        link: <Link href="https://lkdr.nalog.ru/partners/markets">{i18n('ссылке')}</Link>,
                    })}
                </Spoiler>
                <Spoiler className={styles.spoiler} summary={i18n('Как отключить передачу чеков?')}>
                    {i18nRaw('Вы можете в любой момент отключить доступ Едадил к вашим чекам. Перейдите по {link} и кликните по кнопке "Отключить" для партнера Едадил.', {
                        link: <Link href="https://lkdr.nalog.ru/partners">{i18n('ссылке')}</Link>,
                    })}
                </Spoiler>
                <Spoiler className={styles.spoiler} summary={i18n('Где увидеть все кешбэк-акции?')}>
                    {i18nRaw('В разделе {link} в сервисе Едадил.', {
                        link: <Link href="https://edadeal.ru/cashbacks">{i18n('«Кешбэк»')}</Link>,
                    })}
                </Spoiler>
                <Spoiler className={styles.spoiler} summary="Сколько времени занимает подключение?">
                    {i18n('Обычно мы обрабатываем подключение за 20 минут. Иногда, из-за технических задержек, время подключения может увеличиться.')}
                </Spoiler>
                <Spoiler className={styles.spoiler} summary={i18n('Как быстро начислится кешбэк?')}>
                    {i18n('Чеки обрабатываются за 1–3 дня. Если одновременно поступило много чеков — сроки проверки могут увеличиться.')}
                </Spoiler>
            </div>
        </section>
    );
};
