import React, { ReactNode } from 'react';

import { classnames } from '@bem-react/classnames';
import { IClassNameProps } from '@bem-react/core';

import styles from './index.module.css';

interface ISpoilerProps extends IClassNameProps {
    summary: ReactNode;
}
export const Spoiler: React.FC<ISpoilerProps> = ({ className, summary, children }) => {
    return (
        <details className={classnames(styles.container, className)}>
            <summary className={styles.summary}>{summary}</summary>
            <div className={styles.content}>{children}</div>
        </details>
    );
};
