import React from 'react';
import type { ReactNode } from 'react';

import styles from './index.module.css';

type Props = {
    title: string;
    subtitle?: string;
    className?: string;
    action?: ReactNode;
    description: ReactNode;
};

const Error = ({ title, subtitle, action, className, description }: Props) => {
    return (
        <div className={className}>
            <h1 className={styles.title}>
                {title}
                {subtitle && (
                    <>
                        <br />
                        {subtitle}
                    </>
                )}
            </h1>
            <div className={styles.description}>{description}</div>
            {action && <div className={styles.action}>{action}</div>}
        </div>
    );
};

export default Error;
