import React from 'react';
import i18nFactory from '@i18n';
import * as keyset from '@i18n/FamilyShortcut.i18n';
import { IClassNameProps } from '@bem-react/core/core';

import { formatCurrency } from '@client/helpers/number';
import { Shortcut } from '@yandex-id/components';
import useConstants from '@hooks/useConstants';

const i18n = i18nFactory(keyset);

export const FamilyShortcut: React.FC<IClassNameProps> = ({ className }) => {
    const { authInfo } = useConstants();

    const href = authInfo?.user.isFamilyAdmin ?
        'https://passport.yandex.ru/profile/family?utm_source=yandexapp&utm_medium=shortcut&utm_campaign=yafamily&utm_content=for_owner' :
        'https://id.yandex.ru/yafamily?utm_source=yandexapp&utm_medium=shortcut&utm_campaign=yafamily&utm_content=for_members';

    return (
        <Shortcut
            className={className}
            variant="family"
            icon='family'
            size="s"
            href={href}
            currency={formatCurrency('RUB')}
            label={i18n("Для близких")}
            text={i18n("Семейная оплата")}
            target="_blank"
            textBold
        />
    );
};
