import React from 'react';

import { classNames } from '@yandex-int/tap-components/helpers';

import Image from '@components/Image';
import type { Props as ImageProps } from '@components/Image';

import type { Icons, Theme } from './assets';
import icons from './assets';
import styles from './index.module.css';

export type Size = 'xxs' | 's14' | 's16' | 'xs' | 's' | 's28' | 'm' | 'l' | 'xl';

export type Props = Partial<ImageProps> & {
    size?: Size;
    theme?: Theme;
    name: Icons[Theme];
} & JSX.IntrinsicElements['img'];

const SIZES: Record<Size, number> = {
    xxs: 12,
    s14: 14,
    s16: 16,
    xs: 20,
    s: 24,
    s28: 28,
    m: 32,
    l: 48,
    xl: 52,
};

const Icon = ({
    name,
    size,
    className,
    alt = 'icon',
    theme = 'common',
    width,
    height,
    ...componentProps
}: Props) => {
    const icon = icons[theme][name];
    const widthIcon = size ? SIZES[size] : width;
    const heightIcon = size ? SIZES[size] : height;

    return icon ? (
        <Image
            cover
            alt={alt}
            src={icon}
            width={widthIcon}
            height={heightIcon}
            className={classNames(size && styles[size], styles.image, className)}
            {...componentProps}
        />
    ) : null;
};

export default Icon;
