import React, { ReactElement } from 'react';

import { cn } from '@bem-react/classname';

import Icon from '@components/Icon';

import './index.css';

export type IconButtonProps = JSX.IntrinsicElements['div'] & {
    type?: 'default' | 'filled';
    size?: 'm' | 'l';
    children: ReactElement<typeof Icon>;
}

const cnIconButton = cn('IconButton');

const IconButton = ({
    className,
    type = 'default',
    size = 'l',
    children,
    ...rest
}: IconButtonProps) => {
    return (
        <div className={cnIconButton({ type, size }, [className])} {...rest}>
            {children}
        </div>
    );
};

export default IconButton;
