import React from 'react';

import Card from '@client/screens/MainScreen/OrdersHistory/Card';
import CardSceleton from '@components/Card/Skeleton';
import ListDivider from '@components/ListDivider';
import ListOrdersItem from '@components/ListOrders/ListOrdersItem';
import { IOrder } from '@src/types';

import ListOrders from './index';

import { TemplateFactory } from '../../../../.storybook/helpers/TemplateFactory';

const edgeFactory = (created: string) => ({
    id: 'b3JkZXJfMQ==',
    created,
    order_id: 57,
    actualPrice: 100,
    extendedStatus: 'paid',
    payments_order_id: 1,
    service: {
        name: 'Yandex.Taxi',
        iconUrl: 'https://avatars.mds.yandex.net/get-bunker/994123/044507f86c5da0f0ba2d0d8cb3992208be7f546b/svg',
        id: 'taxi',
    },
});

const edgesArrayFactory = (count: number, divider = 4) => {
    const edges = [];

    for (let i = 0, day = 0; i < count; i++) {
        if (i % divider === 0) {
            day++;
        }

        edges.push(edgeFactory(`2021-02-0${day + 1}T20:44:40+${('0' + i).slice(-2)}:00`));
    }

    return edges;
};

const renderRow = (node: IOrder) => <Card data={node} />;

const renderUpdateNotification = () => {
    return (
        <>
            <ListOrdersItem>
                <ListDivider text="loading_list" />
            </ListOrdersItem>
            <ListOrdersItem>
                <CardSceleton />
            </ListOrdersItem>
        </>
    );
};

export default {
    title: 'Component/ListOrders',
    component: ListOrders,
    args: {
        list: edgesArrayFactory(20),
        isUpdating: false,
        renderRow,
        getISODate: (node: IOrder) => node.created,
        renderUpdateNotification,
    },
};

const template = TemplateFactory(ListOrders);

export const Default = template({});

export const Loading = template({ isUpdating: true });
