import React from 'react';

import ListDivider from '@components/ListDivider';
import { useDateAutoFormatter } from '@hooks/useDateFormatters';

import ListOrdersItem from './ListOrdersItem';

interface Props<T> {
    list: T[];
    isUpdating?: boolean;
    getISODate(node: T): string;
    renderRow(node: T): React.ReactElement;
    renderUpdateNotification(): React.ReactElement;
}

const ListOrders: React.FC<Props<ANY>> = ({ list, isUpdating, renderRow, getISODate, renderUpdateNotification }) => {
    const formatDateAuto = useDateAutoFormatter();

    const renderList = React.useMemo(() => {
        let lastDateStamp: string;

        return list.reduce<Array<React.ReactElement | null>>((aux, node, index) => {
            const datestamp = formatDateAuto(getISODate(node), { checkIfToday: true });

            if (datestamp && datestamp !== lastDateStamp) {
                aux.push(
                    <ListOrdersItem key={datestamp}>
                        <ListDivider text={datestamp} />
                    </ListOrdersItem>,
                );

                lastDateStamp = datestamp;
            }

            aux.push(<ListOrdersItem key={`${node.id}_${index}`}>{renderRow(node)}</ListOrdersItem>);

            return aux;
        }, []);
    }, [list, renderRow, getISODate, formatDateAuto]);

    if (!list.length) {
        return null;
    }

    return (
        <>
            {renderList}
            {isUpdating && renderUpdateNotification()}
        </>
    );
};

export default ListOrders;
