import React from 'react';

import { compose } from '@bem-react/core';
import { classNames } from '@yandex-int/tap-components/helpers';
import { withThemeNormal } from '@yandex-lego/components/Modal/touch-phone';
import { Modal as LegoModal } from '@yandex-lego/components/Modal/touch-phone';
import { cnTheme } from '@yandex-lego/components/Theme';
import { theme } from '@yandex-lego/components/Theme/presets/default';
import { withZIndex } from '@yandex-lego/components/withZIndex';

import Icon from '@components/Icon';
import type { Icons, Theme } from '@components/Icon/assets';

import './index.css';

import styles from './index.module.css';

const ComposedLegoModal = compose(withZIndex, withThemeNormal)(LegoModal);

type Props = {
    visible?: boolean;
    className?: string;
    classNameModal?: string;
    closeIcon?: Icons[Theme];
    classNameClose?: string;
    autoFocus?: boolean;
    onClose?: (event: KeyboardEvent | MouseEvent | React.MouseEvent<HTMLElement>, source?: 'esc' | 'click') => void;
};

const Modal: React.FC<Props> = ({
    visible, className, classNameModal, children, onClose, closeIcon, classNameClose, autoFocus,
}) => {
    return (
        <ComposedLegoModal theme="normal" className={classNameModal} visible={visible} onClose={onClose} autoFocus={autoFocus}>
            <div className={classNames(cnTheme(theme), styles.modal, className)}>
                <div className={classNames(styles.close, classNameClose)} onClick={onClose}>
                    <Icon className={styles.close_icon} name={closeIcon || 'close'} />
                </div>
                {children}
            </div>
        </ComposedLegoModal>
    );
};

export default Modal;
